******** UPDATES/NOTES************************************************ 
NOTE: NEED TO RUN FAMSTEP7273.SAS FIRST TO GET PARAMETER ESTIMATES


**********************************************************************;

*%include "~/jim/gzipseq.mcr"; 

LIBNAME pmeters '~/jim/data';
LIBNAME alldat '~/jim/data';

******* FAMILY FILES **********;

FILENAME fmly6061 pipe 'gunzip -c ~/jim/data/ce6061/09035-0001-Data.txt.gz';

DATA cex61;
INFILE fmly6061 LRECL=1748 MISSOVER PAD;
INPUT 
locat 1 yr_id 12 fam_type 34 finlwt 58-62 region 10 stratum 13 state_smsa 4-5
fsize1 28-30 fsize2 1722-1730 earn_comp 37
vehq 57 marital 1713-1721 ref_race 15 educ_code 16 educ_ref 17-18 cutenure 49 cutenure2 50
change_occ 51 houseval 53-54  rentval 55-56 age_ref 20-22 age_ref1 19 sex 14 perslt18 31 
persot64 32 totexp 63-72 totfood 73-82 fdhome 83-92  fdaway 93-102 totalc 103-112 
tothousing 123-132 tottobac 113-122 totshelt 133-142 totrentdwe 143-152  totowndwe 153-162 
OwnVacation 213-222 Floor  403-412 Lodging 223-232 OthRealestate 233-242 Utilites 243-252 
GasElect 263-272 IceWaterfreezer 283-292 tothouseops 293-302 Householdtextiles 343-352 
Furniture 353-362 MajorAppliance 413-422 SmallAppliance 453-462 Housewares 463-472 
HousefurnMisc1 473-482 HousefurnMisc2 483-492 telephone 303-312 housefurnishingtotal 333-342 
Clothingtotal 493-502 Clothingmen18over 503-512 clothingboys16 563-572 
clothingboys16under 623-632 clothingwomen18over 683-692 clothinggirls16 743-752 
clothinggirls16under 803-812 clothingkids 863-872 clothingmaterials 873-882 
clothingupkeep 883-892 Transportation 893-902 automobile 903-912 automobileops 913-922 
Publictransother 983-992 gasoline_oil 923-932 tires 933-942 Operatingexpenses 943-952 
repairs 953-962 vehicinsurance 963-972 registration 973-982 healthcare 993-1002 
healthinsurance 1003-1012 directhealthexpense 1013-1022 personalcare 1093-1102 
recreation 1123-1132 education 1193-1202 music 1223-1232 reading 1183-1192 
personalinsurance 1243-1252 veterans 1253-1262 group_ins 1263-1272 other 1273-1282 
disability 1293-1302 otherpersonalinsur 1303-1312 SSrailgovt 1313-1322 
privatretirement 1323-1332 gifts 1333-1342 tax_inc 1573-1582 selfincome 1583-1592
personaltaxes 1673-1682 othmoney 1683-1692 asset_liab 1363-1372 asset 1373-1382 
liability 1463-1472 asset_cash 1383-1392 asset_stock_bond 1423-1432 
liab_bank 1493-1502 liab_oth1 1513-1522 liab_oth2 1523-1532 liab_oth3 1533-1542 
itemexp 1693-1702 homefood 1703-1712 fincbtax 1563-1572
miscel_tot 1233-1242;

finlwt=finlwt/10;

* FSIZE2 IS CODED UP IN A VERY WHACKY WAY (SEE P. 157 OF CODEBOOK) SO USE FSIZE1;
fam_size=ROUND(fsize1/10);

array decimal 
marital totexp totfood fdhome fdaway totalc tothousing tottobac totshelt
totrentdwe   totowndwe OwnVacation Floor Lodging OthRealestate Utilites GasElect  
IceWaterfreezer tothouseops Householdtextiles Furniture  MajorAppliance  SmallAppliance 
Housewares  HousefurnMisc1 HousefurnMisc2 telephone housefurnishingtotal  Clothingtotal 
Clothingmen18over clothingboys16 clothingboys16under clothingwomen18over
clothinggirls16 clothinggirls16under clothingkids clothingmaterials  clothingupkeep 
Transportation automobile automobileops Publictransother gasoline_oil  tires   
Operatingexpenses  repairs vehicinsurance registration healthcare
healthinsurance directhealthexpense  personalcare recreation education music  reading 
personalinsurance veterans group_ins other disability otherpersonalinsur SSrailgovt   
privatretirement  gifts tax_inc selfincome personaltaxes othmoney 
asset_liab  asset liability  itemexp  homefood fincbtax miscel_tot
asset_cash asset_stock_bond liab_bank liab_oth1 liab_oth2 liab_oth3;

do over decimal;
decimal=decimal/100;
end;

*Total Housing;
tothousing=tothousing-OthRealestate;
*Total Shelter;
totshelter=totshelt+Floor;
*Owned Dwellings;
totowndwe=totowndwe+OwnVacation+Floor;
*Fuel and Utilities, total - subtracting more than appropriate in the category IceWaterfreezer
however this category IceWaterfreezer makes up approximatley 1.55835% of the total Fuel and Utilities
consumption;
Utilites=Utilites-IceWaterfreezer;
*Total Household Operations-adding IceWaterfreezer adds too much but it only constitutes 1.5% of Utitlies and 
Utilites constitutes approximatley 6% of total expenditures;
tothouseops=tothouseops+HousefurnMisc1+HousefurnMisc2+IceWaterfreezer;
*Total Clothing- deduct all of clothing upkeep abou 10% of total clothing 
if we could we would only deduct dry cleaning and pressing, however the data is not
disaggregated that fine;
Clothingtotal=Clothingtotal-clothingupkeep;
*Clothing Males, 2 and over;
Clothingmales=Clothingmen18over+clothingboys16+clothingboys16under;
*Clothing Females, 2 and over;
Clothingfemales=clothingwomen18over+clothinggirls16+clothinggirls16under;
*Materials, repairs, alterations, and services - includes dry cleaning and pressing;
Clothing_mat_rep_alt_ser=clothingmaterials+clothingupkeep;
*Total Vehicle Operations-include planes etc...;
Vehicleoper=automobileops+Publictransother;

*The Following categories all deal with automobile purchases (cars, trucks, self-propelled campers)
*Total Recreation;
totalrecreation=recreation+music;
*total education;
toteducation=education-music;
*Life Endowment, Annuities, and income insurance;
life_endowment_annuity_income=veterans+group_ins+other+disability;
*Retirement and Pensions;
Retirement_pension=SSrailgovt+privatretirement;
*All other income;
all_other_income=fincbtax-selfincome-tax_inc;
*Other Money Receipts;
other_money_receipts=othmoney;
*Goods and Services received without direct expense;
goods_service_no_direct_expense=itemexp+homefood; 

* BOTH CASH CONTRIBUTIONS AND MISCEL EXP NEED TO BE SUBTRACTED FROM TOTAL EXPENDITURES TO 
  MATCH THE DEFINITION OF TOTAL EXPEND IN 72 AND BEYOND.  THE PROBLEM IS THAT THESE CATEGORIES
  ARE NOT DEFINED THE SAME IN 60-61 AS IN 72-73.  MISCEL EXP IS MORE BROADLY DEFINED IN 72-73 
  AND CASH CONTRIBUTION IN 72-73 IS ONLY A SUBSET OF WHAT IS CALLED "GIFTS" IN 6061.  WE DO NOT HAVE
  ACCESS TO DETAILED DATA IN 60-61 TO RECREATE THE SAME CATEGORIES AS IN 72-73.  WE THEREFORE
  SCALE THESE CATEGORIES IN 60-61 TO REFLECT THE DIFFERENCE USING THE RATIO OF MEANS IN 72-73 (SEE famstep7273.lst);

* THIS RATIO FOR MISCEL EXP IS: d_miscel/miscelexp=1.25;
miscel_adj=miscel_tot*1.25;
* THIS RATIO FOR GIFTS IS: d_cashco/cashco= 0.843;
cashco=gifts*0.843;
non_cash_gifts=gifts*(1-0.843);

RUN;

DATA cex61;
set cex61;
id=_N_;

if yr_id=9 then ref_year=1959; 
else if yr_id=0 then ref_year=1960;
else if yr_id=1 then ref_year=1961;

srv_year=61; 

newid=999900000+id;

*taxable income - in 60/61 wages include civilian and non-military where as 
 in 72/73 civilian wages refers to fsalaryX and military wages refer to Fsalaryx2;

*For self-employment (selfincome) worker pasy both parts of FICA;
*If year=1972 then fica=MIN(MAX(0,tax_inc*0.046)+MAX(0,selfincome*0.092),9000);
*else if year-1973 THEN fica=MIN(MAX(0,tax_inc*0.0485)+(MAX(0,selfincome*0.097),10800)
NEED TO DO THIS FICA CALCULATION
for now i will put down fica=0;
fica=0;
*Taxes are negative values;
fincatax=fincbtax+personaltaxes;

*We have no data on weeks worked by the Consumer Unit or employment status for that matter in 
1960-1961 - we therefore can not define incweek1, incweek2, or empstat;

*CHANGE IN ASSETS AND LIABILITIES THAT MATCH 72 AND BEYOND DEFINITION;
chg_asset=SUM(OF asset_cash asset_stock_bond);
chg_liability=SUM(OF liab_bank liab_oth1 liab_oth2 liab_oth3)*(-1);

*In the 72/73 code there are lines devoted to dealing with missing values of renteq (rental equivalent for households)
we do not have a rental equivalent in the 1960/1961 data so we must deal with this by estimating renteq for all 
households 
(and perhaps renters?) by imputing renteq using coefficients from the 72/73 CEX.  I mention this here, but I will also 
mention
this further down in the code when I deal with the houseval (value of housing) variable;

*Married - 6 households dont report whether married or not;
married=0;
if marital=1 then married=1;
else married=0;

*We can not construct a central air (air conditioning) variable because we have no data for this in 1960-61;

*Constructing total expenditure 2 - for comparision between 60-61 and 
 72-73 total current consumption consists of total expenditures in 1960-1961, and this is
 comparable to total current consumption expenses in 72/73.  total expenditure 2 (totexp2) excludes cash contributions
 and miscel exp;

totexp2=totexp+personalinsurance
	- miscel_adj
	+ non_cash_gifts;

*total expenditure minus total expenditures on housing (non-housing);
totexp_nh=totexp2-totowndwe;

*No renteq for households in 60-61, have to predict using coefficient values from 
72/73 or 80/81;
*In 60-61 housevalues (houseval) are separated into 12 categories for houseowners, 
so what we will do is take the midpoint of these categories and assign that value 
to the households that are in said category - the only exceptions are the category of less
than $5000 (we will give a value of $3500) and the category of $50,000 and over 
(which we will give $65,000)- there are 42 home owners (out of 8400) that we will have to 
predict houseval for since they are not reported.  There are 5238 consumer units that are 
renter households for which we do not need a houseval.;

if houseval=10 then houseval2=3500;
else if houseval=20 then houseval2=7500;
else if houseval=31 then houseval2=11250;
else if houseval=32 then houseval2=13750;
else if houseval=41 then houseval2=16250;
else if houseval=42 then houseval2=18750;
else if houseval=51 then houseval2=21250;
else if houseval=52 then houseval2=23750;
else if houseval=60 then houseval2=30000;
else if houseval=71 then houseval2=42500;
else if houseval=72 then houseval2=65000;
else if houseval=99 then houseval2=.;

If houseval2 GT 0 then ln_houseval=LOG(houseval2);

If totexp_nh GT 0 then ln_totexp_nh=LOG(totexp_nh);

If fam_size=1 and married=0 and sex=2 then swnk=1;
else swnk=0;
If fam_size GT 1 and perslt18 GT 0 and married=0 and sex=1 then sm=1;
else sm=0;
if fam_size GT 1 and perslt18 GT 0 and married=1 then mm=1;
else mm=0;

If locat IN (8 9) then bls_urbn=2;
else if 1 LE locat LE 7 then bls_urbn=1; 

IF educ_code IN(1,2,3,8) THEN ed_type=1; 
           ELSE IF educ_code=4 THEN ed_type=2; 
           ELSE IF educ_code=5 THEN ed_type=3;
           ELSE IF educ_code IN(6,7) THEN ed_type=4;
 
ARRAY ed(1:4); 
  DO t=1 TO 4;
     IF ed_type=t THEN ed(t)=1;
       ELSE ed(t)=0; END;

*Changing Poverty cut line to 1961 dollars from 1983 dollars using CPI-U;
if ref_year=1961 and fam_size=1 and age_ref < 65 then Pov_cut= 5180*0.300200803;
else if ref_year=1961 and fam_size=1 and age_ref ge 65 then Pov_cut=4775*0.300200803;
else if ref_year=1961 and fam_size=2 and age_ref ge 65 then Pov_cut= 6863*0.300200803;
else if ref_year=1961 and fam_size=2 and age_ref < 65 then Pov_cut=6837*0.300200803;
else if ref_year=1961 and fam_size=3 then Pov_cut=8022*0.300200803;
else if ref_year=1961 and fam_size=4 then Pov_cut=10133*0.300200803;
else if ref_year=1961 and fam_size=5 then Pov_cut=11701*0.300200803;
else if ref_year=1961 and fam_size=6 then Pov_cut=13056*0.300200803;
else if ref_year=1961 and fam_size=7 then Pov_cut=14315*0.300200803;
else if ref_year=1961 and fam_size=8 then Pov_cut=16244*0.300200803;
else if ref_year=1961 and fam_size ge 9 then Pov_cut=19249*0.300200803;

*Changing Poverty cut line to 1960 dollars from 1983 dollars using CPI-U;
if ref_year=1960 and fam_size=1 and age_ref < 65 then Pov_cut= 5180*0.297188755;
else if ref_year=1960 and fam_size=1 and age_ref ge 65 then Pov_cut=4775*0.297188755;
else if ref_year=1960 and fam_size=2 and age_ref ge 65 then Pov_cut= 6863*0.297188755;
else if ref_year=1960 and fam_size=2 and age_ref < 65 then Pov_cut=6837*0.297188755;
else if ref_year=1960 and fam_size=3 then Pov_cut=8022*0.297188755;
else if ref_year=1960 and fam_size=4 then Pov_cut=10133*0.297188755;
else if ref_year=1960 and fam_size=5 then Pov_cut=11701*0.297188755;
else if ref_year=1960 and fam_size=6 then Pov_cut=13056*0.297188755;
else if ref_year=1960 and fam_size=7 then Pov_cut=14315*0.297188755;
else if ref_year=1960 and fam_size=8 then Pov_cut=16244*0.297188755;
else if ref_year=1960 and fam_size ge 9 then Pov_cut=19249*0.297188755;

*Changing Poverty cut line to 1959 dollars from 1983 dollars using CPI-U;
if ref_year=1959 and fam_size=1 and age_ref < 65 then Pov_cut= 5180*0.292168675;
else if ref_year=1959 and fam_size=1 and age_ref ge 65 then Pov_cut=4775*0.292168675;
else if ref_year=1959 and fam_size=2 and age_ref ge 65 then Pov_cut= 6863*0.292168675;
else if ref_year=1959 and fam_size=2 and age_ref < 65 then Pov_cut=6837*0.292168675;
else if ref_year=1959 and fam_size=3 then Pov_cut=8022*0.292168675;
else if ref_year=1959 and fam_size=4 then Pov_cut=10133*0.292168675;
else if ref_year=1959 and fam_size=5 then Pov_cut=11701*0.292168675;
else if ref_year=1959 and fam_size=6 then Pov_cut=13056*0.292168675;
else if ref_year=1959 and fam_size=7 then Pov_cut=14315*0.292168675;
else if ref_year=1959 and fam_size=8 then Pov_cut=16244*0.292168675;
else if ref_year=1959 and fam_size ge 9 then Pov_cut=19249*0.292168675;


RUN;

*predict value of houseval for 42 home owners with no houseval reported;
proc reg data=cex61 OUTEST=param;
where cutenure=1 and ln_houseval GT 0;
model ln_houseval=ln_totexp_nh fam_size sm mm swnk;
run;

************************************************************
Generate the predicted values of houseval using the 
parameters generated from regression above
************************************************************;
proc score Data=cex61 score=param out=predhome type=parms;
id newid;
var ln_totexp_nh fam_size sm mm swnk;
run;

DATA cex61;
MERGE cex61 predhome(KEEP=newid model1 RENAME=(model1=ln_houseval_pred));
by newid;
*REPLACE 42 OBS WITH MISSING HOUSEVAL;
IF cutenure=1 and ln_houseval=. THEN ln_houseval=ln_houseval_pred;
IF cutenure=1 and houseval2=. THEN houseval3=EXP(ln_houseval_pred);
   ELSE houseval3=houseval2;

RUN;


DATA temp61;
SET cex61;

* PUT NECESSARY VARS IN 72 $S USING CPI-U-RS;
IF ref_year=1959 THEN DO;
   houseval3=houseval3*1.406;
   totexp_nh=totexp_nh*1.406;
   totexp3=(totexp2-automobile)*1.406;
   fincbtax=fincbtax*1.406;
END;
IF ref_year=1960 THEN DO;
   houseval3=houseval3*1.381;
   totexp_nh=totexp_nh*1.381;
   totexp3=(totexp2-automobile)*1.381;
   fincbtax=fincbtax*1.381;
END;
IF ref_year=1961 THEN DO;
   houseval3=houseval3*1.368;
   totexp_nh=totexp_nh*1.368;
   totexp3=(totexp2-automobile)*1.368;
   fincbtax=fincbtax*1.368;
END;
IF houseval3 GT 0 then ln_houseval=LOG(houseval3);
IF totexp_nh GT 0 then ln_totexp_nh=LOG(totexp_nh);
IF totexp3 GT 0 then ln_totexp3=LOG(totexp3);
* A SMALL # OF OBS (< 1%) HAVE FINCBTAX<=0;
IF fincbtax GT 0 then ln_fincbtax=LOG(fincbtax);
   ELSE ln_fincbtax=0;

sex_dum=sex-1;

RUN;

PROC MEANS;
RUN; 

**************************************************************
GENERATE VALUES FOR PREDICTED VALUE OF AUTO PURCHASE VALUE
PER AUTO USING DATA FROM 7273, BECAUSE YOU CANNOT DETERMINE
THE NUMBER OF CARS PURCHASED IN THE 60-61 DATA
**************************************************************;
PROC SCORE DATA=temp61 SCORE=pmeters.car_param7273 OUT=pred_car TYPE=PARMS;
   ID newid;
   VAR ln_totexp3 age_ref ln_fincbtax fam_size sex_dum ed1 ed2 ed3;
RUN; 

PROC MEANS DATA=pred_car;
RUN; 
PROC SORT data=pred_car;
by newid;
RUN;

**************************************************************
Generate predicted values for renteq using the parameters generated 
from regression in 1972-73 that predicts rent equivalent(famstep7273.sas)
**************************************************************;
PROC SCORE DATA=temp61 SCORE=pmeters.house_param7273 OUT=pred_hflow TYPE=PARMS;
   ID newid;
   VAR ln_houseval ln_totexp_nh fam_size sm mm swnk;
RUN; 
 
PROC MEANS DATA=pred_hflow;
RUN; 

proc sort data=pred_hflow;
by newid;
run;

DATA alldat.famstep6061;
MERGE cex61 
      pred_hflow(KEEP=newid model1 RENAME=(model1=ln_renteq_pred))
      pred_car(KEEP=newid model1 RENAME=(model1=ln_car_pred));
by newid;

IF cutenure=1 AND ref_year=1959 THEN renteq=EXP(ln_renteq_pred)*0.7112;
IF cutenure=1 AND ref_year=1960 THEN renteq=EXP(ln_renteq_pred)*0.7240;
IF cutenure=1 AND ref_year=1961 THEN renteq=EXP(ln_renteq_pred)*0.7312;

* USE SAME DEPRECIATION RATE AND AVG AGE AS USED IN 72-73;
delta72=0.1459*1.2613; 
avg_age=3.51; 

IF ref_year=1959 THEN 
  n_tot_vflow1=(vehq*EXP(ln_car_pred)*0.7112)*(delta72)*(1-delta72)**(avg_age);
IF ref_year=1960 THEN 
  n_tot_vflow1=(vehq*EXP(ln_car_pred)*0.7240)*(delta72)*(1-delta72)**(avg_age);
IF ref_year=1961 THEN 
  n_tot_vflow1=(vehq*EXP(ln_car_pred)*0.7312)*(delta72)*(1-delta72)**(avg_age);

* ABOUT 75% OF THOSE W/ CUTENURE=2 HAVE SMALL POSITIVE SPENDING ON TOTOWNDWE;
IF cutenure=2 THEN hflow=totowndwe;
   ELSE IF cutenure=1 THEN hflow=renteq*12;
   	
*Note that in developing tflow, totowndwe in 60/61 includes spending on hard floor surfaces 
where as 72/73 does not;
tflow=(totexp2 + n_tot_vflow1 +hflow 
	   -totowndwe
	   -Automobile
	   -healthcare
	   -toteducation
	   -Retirement_pension);

*In the core_cons, vehicle finances for 60/61 are included in the vehicle purchase information
which is in the n_tot_vflow1 variable, in 72/73 there is a separate category for vehicle finances
Also it should be noted that utilites in 1960/61 does not Ice and Food Freezer rentals which should not be 
included if we want a correct comparision with 72/73 however we must include because we can not 
disagreggate utility expenditure down to that fine of a level;

core_cons=fdhome+totrentdwe+Utilites+automobileops+Publictransother+n_tot_vflow1 +hflow;


***********************************
Offical Income Poverty
***********************************;

*We have no data on foodstamps (foodstamps not around in 60/61) in 60/61 just 
an overall number for public assistance
therefore we can not create the food stamp variable so that part of the 72/73 code is omitted;
fstamp=.;
*fstamp=-1*foodstamp;
IF fincbtax=. then official_pov=.;
else if (fincbtax)<pov_cut then official_pov=1;
else official_pov=0;

scale=((fam_size-perslt18+.7*perslt18)**.7);
*adjusted total expenditures;
cons1=(totexp2)/scale/4;

*consumption, no gov't housing adj, no HI;
*cons2=(tflow)/scale/4;
*consumption including education spending;
cons2=(tflow+toteducation)/scale/4;

*main consumption;
cons3=(tflow)/scale/4;

*unadjusted total expenditures;
cons4=(totexp)/scale/4;

*consumption plus MOOP;
*cons5=(tflow + healthcare)/scale/4;
*Core consumption;
cons5=(core_cons)/scale/4;

*consumption no HI;
cons6=(tflow)/scale/4;
*ask about this;

*non-housing consumption;
cons7=(tflow-SUM(OF totrentdwe hflow))/scale/4;

*before tax income;
cons8=fincbtax/scale;

*after tax income
*fica is not defined - Pr. Sullivan will define it
other_money_receipts = nonincmx);
cons9=(fincatax+other_money_receipts-fica)/scale;

If married=0 and sex=2 and perslt18 GT 0 and fam_size GT 1
Then wgt23=finlwt*fam_size;
else wgt23=0;

If totexp2<pov_cut then pov1=finlwt;
else pov1=0;
If tflow<pov_cut then pov2=finlwt;
else pov2=0;
if tflow<pov_cut then pov3=finlwt;
else pov3=0;

gap1=(max(0,pov_cut-MAX(0,totexp2)))*finlwt;
gap2=(max(0,pov_cut-MAX(0,tflow)))*finlwt;
gap3=(max(0,pov_cut-MAX(0,tflow)))*finlwt;

* RESPONDENTS ARE SURVEYED IN 1959, 1960, AND 1961, BUT MUST COMBINE THESE TO BE REPRESENTATIVE
  OF POPULATION, SO TREAT AS JUST ONE YEAR. PUT ALL IN 1961 PRICES;

IF ref_year=1959 THEN DO;
   cons1=cons1*1.028;
   cons2=cons2*1.028;
   cons3=cons3*1.028;
   cons4=cons4*1.028;
   cons5=cons5*1.028;
   cons6=cons6*1.028;
   cons7=cons7*1.028;
   cons8=cons8*1.028;
   cons9=cons9*1.028;
END;
IF ref_year=1960 THEN DO;
   cons1=cons1*1.0098;
   cons2=cons2*1.0098;
   cons3=cons3*1.0098;
   cons4=cons4*1.0098;
   cons5=cons5*1.0098;
   cons6=cons6*1.0098;
   cons7=cons7*1.0098;
   cons8=cons8*1.0098;
   cons9=cons9*1.0098;
END;

ref_year=1961;

* "EXCLUDE" VARIABLE IS FOR INC NONRESPONDERS 1980-05; 
exclude=0; 
* "RESPONDENT" VARIABLE IS FOR INC NONRESPONDERS 1980-05; 
respstat=1; 


RUN; 

PROC MEANS;
RUN; 

*%gzipsq(work,famstep6061,~/jim/data);


